set more off
cap log close
clear
set virtual on

log using regression_analysis, replace
* This program computes the estimated MSA fixed effects and compares them in the public and private sector
* Observed and corrected unbiased estimates are presented


tempfile basedat rfedat 
global varlist="tot_med inpat_exp outpat_exp rx_exp no_hosp days_hosp outpat_vis rx_30de"
global varlist_ex="tot_med inpat_exp outpat_exp rx_exp"
global varlist_ut="no_hosp days_hosp outpat_vis rx_30de"


use analytic_file, clear
* Convert dollar values into thousands
foreach i in $varlist_ex {
replace `i'=`i'/1000
}

save "`basedat'", replace

*** BASELINE ESTIMATES *** 

** REGRESSION ESTIMATES **

* Step 1: Regression

foreach i in $varlist {

* Private regressions
reg `i' MSA2-MSA99 age age2 male age_male age2_male income income2 dz_2-dz_30 Y2-Y7 if mcbs==0, robust
est store `i'_priv

* Public regressions
reg `i' MSA2-MSA99 age age2 male age_male age2_male income income2 dz_2-dz_30 Y2-Y7 if mcbs==1, robust
est store `i'_pub

}

* Construct private estimates
foreach i in $varlist {
est restore `i'_priv
matrix A=e(V)
* Private coefficient estimates
scalar `i'_e1=0
for ZZ in num 2/99: scalar `i'_eZZ=_b[MSAZZ]
* Private coefficient variances
scalar `i'_v1=0
for ZZ in num 2/99 \ XX in num 1/98: scalar `i'_vZZ=A[XX,XX]

scalar `i'_priv_cv=0
forvalues xx=1(1)98 {
forvalues mm =1(1)98 {
scalar `i'_priv_cv=`i'_priv_cv+A[`mm',`xx']
}
}
}

* Construct public estimates
foreach i in $varlist {
est restore `i'_pub
matrix A=e(V)
* Private coefficient estimates
scalar `i'_pe1=0
for ZZ in num 2/99: scalar `i'_peZZ=_b[MSAZZ]
* Private coefficient variances
scalar `i'_pv1=0
for ZZ in num 2/99 \ XX in num 1/98: scalar `i'_pvZZ=A[XX,XX]

scalar `i'_pub_cv=0
forvalues xx=1(1)98 {
forvalues mm =1(1)98 {
scalar `i'_pub_cv=`i'_pub_cv+A[`mm',`xx']
}
}
}

foreach i in $varlist {

use "`basedat'", clear
drop dz* Y* mcbs MSA*

gen `i'_MSA1=0
gen `i'_MSA_v1=0

gen `i'_MSA_pub1=0
gen `i'_MSA_pub_v1=0

for JJ in num 2/99: gen `i'_MSAJJ=`i'_eJJ \ gen `i'_MSA_vJJ=`i'_vJJ
for JJ in num 2/99: gen `i'_MSA_pubJJ=`i'_peJJ \ gen `i'_MSA_pub_vJJ=`i'_pvJJ

gen `i'_cov=`i'_priv_cv
gen `i'_pub_cov=`i'_pub_cv

keep `i'_MSA* `i'_cov `i'_pub_cov

duplicates drop
reshape long `i'_MSA `i'_MSA_pub `i'_MSA_v `i'_MSA_pub_v , i(`i'_cov `i'_pub_cov) j(msa)

cap append using "`rfedat'"
save "`rfedat'", replace
}


* Load the data and compute the baseline corrections

use "`rfedat'", clear


foreach i in $varlist {

* Private
sum `i'_MSA
scalar `i'_sd=r(sd)
scalar `i'_v=r(sd)^2
sum `i'_MSA_v
scalar v`i'=r(mean)
sum `i'_cov
scalar `i'_samperr=v`i'-(r(mean)/(r(N)^2))
display `i'_samperr
scalar `i'_v_cor=`i'_v-`i'_samperr

* Public
qui sum `i'_MSA_pub
scalar `i'_pub_sd=r(sd)
scalar `i'_pub_v=r(sd)^2
qui sum `i'_MSA_pub_v
scalar v`i'_pub=r(mean)
qui sum `i'_pub_cov
scalar `i'_pub_samperr=v`i'_pub-(r(mean)/(r(N)^2))
display `i'_pub_samperr
scalar `i'_pub_v_cor=`i'_pub_v-`i'_pub_samperr

* Public private differences
scalar `i'_var_diff=`i'_pub_v-`i'_v
scalar `i'_var_diff_cor=`i'_pub_v_cor-`i'_v_cor

* Public private ratios
scalar `i'_var_rat=`i'_pub_v/`i'_v
scalar `i'_var_rat_cor=`i'_pub_v_cor/`i'_v_cor

}

foreach i in $varlist {

matrix `i'_A= [`i'_v, `i'_pub_v, `i'_samperr, `i'_pub_samperr, `i'_v_cor, `i'_pub_v_cor, `i'_var_diff, `i'_var_diff_cor, `i'_var_rat, `i'_var_rat_cor]

}

matrix ut= [ no_hosp_A \ days_hosp_A \ outpat_vis_A \ rx_30de_A ]
matrix ex= [ tot_med_A \ inpat_exp_A \ outpat_exp_A \ rx_exp_A]

matrix colnames ut= var_obs var_obs_pub var_corection var_corection_pub var_cor var_cor_pub var_diff_obs var_diff_cor var_rat var_rat_cor
matrix colnames ex= var_obs var_obs_pub var_corection var_corection_pub var_cor var_cor_pub var_diff_obs var_diff_cor var_rat var_rat_cor
matrix rownames ut=$varlist_ut
matrix rownames ex=$varlist_ex



* DISPLAY RESULTS
* Utilization
matrix list ut, format(%9.5fc)

* Spending
matrix list ex, format(%9.5fc)



